# 清空以前的数据, 输出这次的时间
import time
LocalTime = time.localtime()
formatted_time = time.strftime("%Y-%m-%d %H:%M:%S", LocalTime)
with open("output.txt", "w", encoding="utf-8") as f:
    f.write(formatted_time + "导出")

# 初始化
    RecentChange = 0
    MajorChapterName = ""
    MinorChapterName = ""

# 加载初始数据, 只需要将原始扫描数据data1.txt, 放在对应文件夹下即可
import json
with open("data1.txt", "r", encoding="utf-8") as file:
    data = json.load(file)

for item in data["words_result"]:
    # 更正一些翻译错误
    item["words"] = item["words"].replace(",","，")

    # 先寻找疾病名字, 根据 第_章 判断, 注意大部分疾病是单独成章
    if "章" in item["words"] and item["words"].startswith("第"):
        MajorChapterName = item["words"].split("章")[1]
        # 为了考虑到大病中的小病的介绍, 引入RecentChange, 当RecentChange == 0时, 只写大病
        # 当RecentChange == 1时, 大小病一块写
        RecentChange = 0
        # 开新的一段
        item["words"] = "\n\n" + item["words"]

# 先寻找疾病名字，根据 第_节 判断, 注意小部分疾病是单独成节
    if "节" in item["words"] and item["words"].startswith("第"):
        MinorChapterName = item["words"].split("节")[1]
        # 为了考虑到大病中的小病的介绍, 引入RecentChange, 当RecentChange == 0时, 只写大病
        # 当RecentChange == 1时, 大小病一块写
        RecentChange = 1
        # 开新的一段
        item["words"] = "\n" + item["words"]

# 将疾病名字插入每一个描述之前
    if item["words"].startswith("【"):
        # 为了考虑到大病中的小病的介绍, 引入RecentChange, 当RecentChange == 0时, 只写大病
        # 当RecentChange == 1时, 大小病一块写
        if RecentChange == 0:
            item["words"] = f"\n【{MajorChapterName}的{item["words"][1:]}"
        if RecentChange == 1:
            item["words"] = f"\n【{MajorChapterName}（{MinorChapterName}）的{item["words"][1:]}"

    # 分段, 如果满足分段条件就开新的一段
    if item["words"].startswith("（") or "." == item["words"][2:3] or "." == item["words"][1:2]:
        item["words"] = "\n" + item["words"]

    # 最后导出, 导出到当前文件夹下的output.txt
combined_text = "".join([item["words"] for item in data["words_result"]])
with open("output.txt", "a", encoding="utf-8") as f:
    f.write(combined_text)
